/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.Handler;
import com.ibm.logging.LogUtil;
import com.ibm.logging.NestedException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;

public class ConsoleHandler
extends Handler {
    private static final String CR = "(C) Copyright IBM Corp. 1998.";
    static final long serialVersionUID = -725355484481958593L;

    public ConsoleHandler() {
    }

    public ConsoleHandler(String string) {
        super(string);
    }

    public ConsoleHandler(String string, String string2) {
        super(string, string2);
    }

    public void closeDevice() {
        Object object = this.deviceLock;
        synchronized (object) {
            this.pWriter = null;
            this.deviceOpen = false;
        }
    }

    public void openDevice() throws NestedException {
        this.closeDevice();
        this.openPrintStream(System.out);
    }

    protected void openPrintStream(PrintStream printStream) throws NestedException {
        Object object = this.deviceLock;
        synchronized (object) {
            try {
                String string = LogUtil.getConsoleCodePage();
                OutputStreamWriter outputStreamWriter = string != null && this.getClass().getClassLoader() == null ? new OutputStreamWriter((OutputStream)printStream, string) : new OutputStreamWriter(printStream);
                this.pWriter = new PrintWriter((Writer)outputStreamWriter, true);
                this.deviceOpen = true;
            }
            catch (Exception exception) {
                String string = LogUtil.getLogMessage("ERR_OPEN_FILE", printStream);
                throw new NestedException(string, exception);
            }
        }
    }
}

