/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.FileHandler;
import com.ibm.logging.Formatter;
import com.ibm.logging.ILogRecord;
import com.ibm.logging.NestedException;
import java.io.File;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;

public class DailyFileHandler
extends FileHandler {
    private static final String CR = "(C) Copyright IBM Corp. 2001.";
    static final long serialVersionUID = 8292583038735285035L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_DAY = 86400000L;
    private transient boolean daylightTime;
    private transient Formatter dateFormatter;
    private transient long today;

    public DailyFileHandler() {
    }

    public DailyFileHandler(String string) {
        super(string);
    }

    public DailyFileHandler(String string, String string2) {
        super(string, string2);
    }

    public DailyFileHandler(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public DailyFileHandler(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    private void buildWorkingName() {
        int n;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = this.getFileName();
        String string5 = new File(string4).getAbsolutePath();
        File file = new File(string5);
        string2 = file.getParent();
        if (string2 != null && !string2.endsWith(File.separator)) {
            string2 = String.valueOf(string2) + File.separator;
        }
        if ((n = (string5 = file.getName()).lastIndexOf(46)) == -1) {
            string = string5;
        } else {
            string = string5.substring(0, n);
            string3 = string5.substring(n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(String.valueOf(string) + "_" + this.dateFormatter.getDate(System.currentTimeMillis()));
        if (string3 != null) {
            stringBuffer.append(string3);
        }
        this.fileName = stringBuffer.toString();
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        ((Hashtable)properties).put("dateFormat", this.getDateFormat().toPattern());
        return properties;
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormatter.getDateFormat();
    }

    private long getToday(long l) {
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        if (this.daylightTime) {
            n = (int)((long)n + 3600000L);
        }
        return (l + (long)n) / 86400000L;
    }

    public void init() {
        super.init();
        if (this.dateFormatter == null) {
            this.dateFormatter = new Formatter();
        }
        long l = System.currentTimeMillis();
        this.daylightTime = this.isDaylightTime(l);
        this.today = this.getToday(l);
    }

    private boolean isDaylightTime(long l) {
        boolean bl = false;
        if (TimeZone.getDefault().inDaylightTime(new Date(l))) {
            bl = true;
        }
        return bl;
    }

    public void openDevice() throws NestedException {
        Object object = this.deviceLock;
        synchronized (object) {
            long l = System.currentTimeMillis();
            long l2 = this.getToday(l);
            if (!this.deviceOpen || this.today != l2) {
                this.closeDevice();
                this.today = l2;
                this.daylightTime = this.isDaylightTime(l);
                this.setFileName(this.orgFileName);
                super.openDevice();
            }
        }
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("dateFormat");
        if (string != null) {
            this.setDateFormat(string);
        }
    }

    public void setDateFormat(String string) {
        if (string != null) {
            this.dateFormatter.setDateFormat(string);
        }
    }

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat != null) {
            this.dateFormatter.setDateFormat(simpleDateFormat);
        }
    }

    public void setFileName(String string) throws AccessControlException {
        if (string != null) {
            super.setFileName(string);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                this.buildWorkingName();
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        DailyFileHandler.this.buildWorkingName();
                        return null;
                    }
                });
            }
        }
    }

    protected void writeRecord(ILogRecord iLogRecord) throws NestedException {
        this.openDevice();
        super.writeRecord(iLogRecord);
    }
}

