/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.IConstants;
import com.ibm.logging.IFormatter;
import com.ibm.logging.ILogRecord;
import com.ibm.logging.LogObject;
import com.ibm.logging.MessageCatalog;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;

public class Formatter
extends LogObject
implements IConstants,
IFormatter {
    private static final String CR = "(C) Copyright IBM Corp. 1998, 1999.";
    static final long serialVersionUID = -3280239333163654498L;
    private static final int DEFAULT_MSG_CATS = 6;
    public static final String DEFAULT_DATE_FORMAT = "yyyy.MM.dd";
    public static final String DEFAULT_TIME_FORMAT = "HH:mm:ss.SSS";
    public static final String DEFAULT_SEPARATOR = " ";
    protected static final String INDENT = "  ";
    private static final String[] attribs = new String[]{"loggingClass", "loggingMethod", "organization", "product", "component", "client", "server"};
    private transient MessageCatalog textCat = new MessageCatalog(null);
    private final transient Object dateLock = new Object();
    private final transient Object timeLock = new Object();
    private boolean localizedDate;
    private boolean localizedTime;
    private transient Date date;
    private transient Date time;
    private transient FieldPosition dateField;
    private transient FieldPosition timeField;
    private transient Hashtable msgCats;
    private int maxMsgCats;
    private Locale locale;
    private SimpleDateFormat dateFormat;
    private SimpleDateFormat timeFormat;
    private String separator;
    protected transient String lineSep;
    private transient StringBuffer dateBuffer;
    private transient StringBuffer timeBuffer;
    static /* synthetic */ Class class$com$ibm$logging$Formatter;

    public Formatter() {
    }

    public Formatter(String string) {
        super(string);
    }

    public Formatter(String string, String string2) {
        super(string, string2);
    }

    protected String bytesToHex(byte[] byArray) {
        int n = 1;
        StringWriter stringWriter = new StringWriter();
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3;
            int n4 = Math.min(n2 + 32, byArray.length);
            StringBuffer stringBuffer = new StringBuffer();
            int n5 = n2;
            while (n5 < n4) {
                n3 = byArray[n5];
                if (n3 < 0) {
                    n3 += 256;
                }
                String string = Integer.toString(n3, 16).toUpperCase();
                if (n3 < 16) {
                    string = "0" + string;
                }
                stringWriter.write(string);
                if (n % 16 == 0) {
                    stringWriter.write(INDENT);
                } else if (n % 2 == 0) {
                    stringWriter.write(DEFAULT_SEPARATOR);
                }
                ++n;
                if (n3 >= 32 && n3 <= 126) {
                    stringBuffer.append((char)n3);
                } else {
                    stringBuffer.append('.');
                }
                ++n5;
            }
            n3 = 32 - (n4 - n2);
            int n6 = 0;
            while (n6 < n3) {
                stringWriter.write(INDENT);
                if (n % 16 == 0) {
                    stringWriter.write(INDENT);
                } else if (n % 2 == 0) {
                    stringWriter.write(DEFAULT_SEPARATOR);
                }
                ++n;
                ++n6;
            }
            stringWriter.write(stringBuffer.toString());
            stringWriter.write(this.lineSep);
            stringWriter.write(INDENT);
            n2 += 32;
        }
        return stringWriter.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String format(ILogRecord iLogRecord) {
        String string = this.getSeparator();
        StringBuffer stringBuffer = new StringBuffer(256);
        long l = iLogRecord.getTimeStamp();
        stringBuffer.append(String.valueOf(this.getDate(l)) + string);
        stringBuffer.append(String.valueOf(this.getTime(l)) + string);
        int n = 0;
        while (n < attribs.length) {
            String string2 = (String)iLogRecord.getAttribute(attribs[n]);
            if (string2 != null) {
                stringBuffer.append(String.valueOf(string2) + string);
            }
            ++n;
        }
        stringBuffer.append(this.lineSep);
        stringBuffer.append(INDENT + this.getText(iLogRecord));
        return stringBuffer.toString();
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        if (this.localizedDate) {
            ((Hashtable)properties).put("dateFormat", "LOCALIZED");
        } else {
            ((Hashtable)properties).put("dateFormat", this.getDateFormat().toPattern());
        }
        if (this.localizedTime) {
            ((Hashtable)properties).put("timeFormat", "LOCALIZED");
        } else {
            ((Hashtable)properties).put("timeFormat", this.getTimeFormat().toPattern());
        }
        ((Hashtable)properties).put("separator", this.getSeparator());
        ((Hashtable)properties).put("maxMsgCats", Integer.toString(this.getMaxMessageCatalogs()));
        return properties;
    }

    public String getDate(long l) {
        Object object = this.dateLock;
        synchronized (object) {
            this.date.setTime(l);
            this.dateBuffer.setLength(0);
            StringBuffer stringBuffer = this.dateFormat.format(this.date, this.dateBuffer, this.dateField);
            String string = stringBuffer.toString();
            Object var5_5 = null;
            return string;
        }
    }

    public SimpleDateFormat getDateFormat() {
        return this.dateFormat;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getMaxMessageCatalogs() {
        return this.maxMsgCats;
    }

    protected String getMessage(ILogRecord iLogRecord) {
        StringBuffer stringBuffer = new StringBuffer(256);
        String string = iLogRecord.getText();
        if (!string.equals("")) {
            Object[] objectArray = iLogRecord.getParameters();
            String string2 = iLogRecord.getMessageFile();
            if (string2 == null) {
                stringBuffer.append(this.textCat.formatMessage(string, objectArray));
            } else {
                MessageCatalog messageCatalog = this.getMessageCatalog(string2);
                stringBuffer.append(messageCatalog.getMessage(string, objectArray));
            }
        }
        return stringBuffer.toString();
    }

    protected MessageCatalog getMessageCatalog(String string) {
        Locale locale = this.getLocale();
        MessageCatalog messageCatalog = (MessageCatalog)this.msgCats.get(string);
        if (messageCatalog != null) {
            if (!locale.equals(messageCatalog.getLocale())) {
                messageCatalog.setLocale(locale);
            }
        } else {
            messageCatalog = new MessageCatalog(string, locale);
            Class clazz = class$com$ibm$logging$Formatter != null ? class$com$ibm$logging$Formatter : (class$com$ibm$logging$Formatter = Formatter.class$("com.ibm.logging.Formatter"));
            synchronized (clazz) {
                if (this.msgCats.size() >= this.getMaxMessageCatalogs()) {
                    Enumeration enumeration = this.msgCats.keys();
                    String string2 = (String)enumeration.nextElement();
                    int n = ((MessageCatalog)this.msgCats.get(string2)).getHitCount();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        int n2 = ((MessageCatalog)this.msgCats.get(string3)).getHitCount();
                        if (n2 >= n) continue;
                        string2 = string3;
                        n = n2;
                    }
                    this.msgCats.remove(string2);
                }
                this.msgCats.put(string, messageCatalog);
            }
        }
        return messageCatalog;
    }

    public String getSeparator() {
        return this.separator;
    }

    protected String getText(ILogRecord iLogRecord) {
        String string;
        Object[] objectArray;
        StringBuffer stringBuffer = new StringBuffer(256);
        String string2 = iLogRecord.getText();
        if (!string2.equals("")) {
            objectArray = iLogRecord.getParameters();
            string = iLogRecord.getMessageFile();
            if (string == null) {
                stringBuffer.append(this.textCat.formatMessage(string2, objectArray));
            } else {
                MessageCatalog messageCatalog = this.getMessageCatalog(string);
                stringBuffer.append(messageCatalog.getMessage(string2, objectArray));
            }
        }
        if ((objectArray = (Object[])((byte[])iLogRecord.getAttribute("hexData"))) != null) {
            stringBuffer.append(this.bytesToHex((byte[])objectArray));
        }
        if ((string = (String)iLogRecord.getAttribute("throwableTrace")) != null) {
            if (!string2.equals("")) {
                stringBuffer.append(String.valueOf(this.lineSep) + INDENT);
            }
            stringBuffer.append(string);
        } else {
            stringBuffer.append(this.lineSep);
        }
        return stringBuffer.toString();
    }

    public String getTime(long l) {
        Object object = this.timeLock;
        synchronized (object) {
            this.time.setTime(l);
            this.timeBuffer.setLength(0);
            StringBuffer stringBuffer = this.timeFormat.format(this.time, this.timeBuffer, this.timeField);
            String string = stringBuffer.toString();
            Object var5_5 = null;
            return string;
        }
    }

    public SimpleDateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void init() {
        super.init();
        if (this.date == null) {
            this.date = new Date();
        }
        if (this.time == null) {
            this.time = new Date();
        }
        this.setMaxMessageCatalogs(6);
        if (this.dateField == null) {
            this.dateField = new FieldPosition(0);
        }
        if (this.timeField == null) {
            this.timeField = new FieldPosition(0);
        }
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        this.localizedDate = false;
        this.localizedTime = false;
        TimeZone timeZone = TimeZone.getDefault();
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat();
            this.setDateFormat(DEFAULT_DATE_FORMAT);
            this.dateFormat.setTimeZone(timeZone);
        }
        if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat();
            this.setTimeFormat(DEFAULT_TIME_FORMAT);
            this.timeFormat.setTimeZone(timeZone);
        }
        this.setSeparator(DEFAULT_SEPARATOR);
        this.lineSep = System.getProperty("line.separator");
        if (this.dateBuffer == null) {
            this.dateBuffer = new StringBuffer();
        }
        if (this.timeBuffer == null) {
            this.timeBuffer = new StringBuffer();
        }
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("dateFormat");
        if (string != null) {
            if (string.equals("LOCALIZED")) {
                this.localizedDate = true;
                this.setDateFormat();
            } else {
                this.localizedDate = false;
                this.setDateFormat(string);
            }
        }
        if ((string = properties.getProperty("timeFormat")) != null) {
            if (string.equals("LOCALIZED")) {
                this.localizedTime = true;
                this.setTimeFormat();
            } else {
                this.localizedTime = false;
                this.setTimeFormat(string);
            }
        }
        if ((string = properties.getProperty("separator")) != null) {
            this.setSeparator(string);
        }
        if ((string = properties.getProperty("maxMsgCats")) != null) {
            this.setMaxMessageCatalogs(new Integer(string));
        }
    }

    public void setDateFormat() {
        try {
            DateFormat dateFormat = DateFormat.getDateInstance(3, this.getLocale());
            this.dateFormat = (SimpleDateFormat)dateFormat;
        }
        catch (Exception exception) {
            this.dateFormat = new SimpleDateFormat();
            this.setDateFormat(DEFAULT_DATE_FORMAT);
        }
        this.dateFormat.setTimeZone(TimeZone.getDefault());
    }

    public void setDateFormat(String string) {
        if (string != null) {
            this.dateFormat.applyPattern(string);
        }
    }

    public void setDateFormat(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat != null) {
            this.dateFormat = simpleDateFormat;
        }
    }

    public void setLocale(Locale locale) {
        if (locale != null) {
            this.locale = locale;
        }
    }

    public void setMaxMessageCatalogs(int n) {
        if (n > 0) {
            this.maxMsgCats = n;
            this.msgCats = new Hashtable(this.maxMsgCats);
        }
    }

    public void setSeparator(String string) {
        if (string != null) {
            this.separator = string;
        }
    }

    public void setTimeFormat() {
        try {
            DateFormat dateFormat = DateFormat.getTimeInstance(3, this.getLocale());
            this.timeFormat = (SimpleDateFormat)dateFormat;
        }
        catch (Exception exception) {
            this.timeFormat = new SimpleDateFormat();
            this.setTimeFormat(DEFAULT_TIME_FORMAT);
        }
        this.timeFormat.setTimeZone(TimeZone.getDefault());
    }

    public void setTimeFormat(String string) {
        if (string != null) {
            this.timeFormat.applyPattern(string);
        }
    }

    public void setTimeFormat(SimpleDateFormat simpleDateFormat) {
        if (simpleDateFormat != null) {
            this.timeFormat = simpleDateFormat;
        }
    }
}

