/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.IConstants;
import com.ibm.logging.IHandler;
import com.ibm.logging.ILogRecord;
import com.ibm.logging.ILogger;
import com.ibm.logging.IRecordType;
import com.ibm.logging.LogRecord;
import com.ibm.logging.LogUtil;
import com.ibm.logging.LoggerCfg;
import com.ibm.logging.utilities.LogStackTrace;
import java.util.Enumeration;

public class Logger
extends LoggerCfg
implements IConstants,
IRecordType,
ILogger {
    private static final String CR = "(C) Copyright IBM Corp. 1998, 1999.";
    static final long serialVersionUID = 7929875764645000092L;
    public static final String ENTRY = "Entry";
    public static final String ENTRY_ONE_PARM = "Entry, parm 1 = {0}";
    public static final String ENTRY_TWO_PARMS = "Entry, parm 1 = {0}, parm 2 = {1}";
    public static final String EXIT = "Exit";
    public static final String EXIT_RC = "Exit, return code = {0}";
    protected transient int handlerFailures;

    public Logger() {
    }

    public Logger(String string) {
        super(string);
    }

    public Logger(String string, String string2) {
        super(string, string2);
    }

    public void data(long l, Object object, String string, byte[] byArray) {
        if (this.isLogging) {
            String string2 = object instanceof String ? (String)object : object.getClass().getName();
            LogRecord logRecord = new LogRecord(l, string2, string, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer(), byArray);
            this.log(logRecord);
        }
    }

    public void entry(long l, Object object, String string) {
        if (this.isLogging) {
            this.logRecord(l |= 0x80L, object, string, ENTRY, null, null);
        }
    }

    public void entry(long l, Object object, String string, Object object2) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{object2};
            this.logRecord(l |= 0x80L, object, string, ENTRY_ONE_PARM, null, objectArray);
        }
    }

    public void entry(long l, Object object, String string, Object object2, Object object3) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{object2, object3};
            this.logRecord(l |= 0x80L, object, string, ENTRY_TWO_PARMS, null, objectArray);
        }
    }

    public void entry(long l, Object object, String string, Object[] objectArray) {
        if (this.isLogging) {
            l |= 0x80L;
            StringBuffer stringBuffer = new StringBuffer(ENTRY);
            if (objectArray != null) {
                int n = 0;
                while (n < objectArray.length) {
                    stringBuffer.append(", parm " + (n + 1) + " = {" + n + "}");
                    ++n;
                }
            }
            this.logRecord(l, object, string, stringBuffer.toString(), null, objectArray);
        }
    }

    public void exception(long l, Object object, String string, Throwable throwable) {
        if (this.isLogging) {
            this.logRecord(l, object, string, throwable);
        }
    }

    public void exit(long l, Object object, String string) {
        if (this.isLogging) {
            this.logRecord(l |= 0x100L, object, string, EXIT, null, null);
        }
    }

    public void exit(long l, Object object, String string, byte by) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{new Byte(by)};
            this.logRecord(l |= 0x100L, object, string, EXIT_RC, null, objectArray);
        }
    }

    public void exit(long l, Object object, String string, char c) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{new Character(c)};
            this.logRecord(l |= 0x100L, object, string, EXIT_RC, null, objectArray);
        }
    }

    public void exit(long l, Object object, String string, double d) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{new Double(d)};
            this.logRecord(l |= 0x100L, object, string, EXIT_RC, null, objectArray);
        }
    }

    public void exit(long l, Object object, String string, float f) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{new Float(f)};
            this.logRecord(l |= 0x100L, object, string, EXIT_RC, null, objectArray);
        }
    }

    public void exit(long l, Object object, String string, int n) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{new Integer(n)};
            this.logRecord(l |= 0x100L, object, string, EXIT_RC, null, objectArray);
        }
    }

    public void exit(long l, Object object, String string, long l2) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{new Long(l2)};
            this.logRecord(l |= 0x100L, object, string, EXIT_RC, null, objectArray);
        }
    }

    public void exit(long l, Object object, String string, Object object2) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{object2};
            this.logRecord(l |= 0x100L, object, string, EXIT_RC, null, objectArray);
        }
    }

    public void exit(long l, Object object, String string, short s) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{new Short(s)};
            this.logRecord(l |= 0x100L, object, string, EXIT_RC, null, objectArray);
        }
    }

    public void exit(long l, Object object, String string, boolean bl) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{new Boolean(bl)};
            this.logRecord(l |= 0x100L, object, string, EXIT_RC, null, objectArray);
        }
    }

    public void init() {
        super.init();
        this.handlerFailures = 0;
    }

    public void log(ILogRecord iLogRecord) {
        if (iLogRecord != null && this.isLoggable(iLogRecord)) {
            Enumeration enumeration = this.getHandlers();
            if (enumeration.hasMoreElements()) {
                ++this.loggedRecordCount;
                while (enumeration.hasMoreElements()) {
                    IHandler iHandler = (IHandler)enumeration.nextElement();
                    if (!iHandler.isLoggable(iLogRecord)) continue;
                    iHandler.logRecord(iLogRecord, this.isSynchronous());
                }
                this.handlerFailures = 0;
            } else if (this.handlerFailures == 0) {
                LogUtil.errorMsg(LogUtil.getLogMessage("ERR_NO_HANDLERS", this.getName()));
                ++this.handlerFailures;
            }
        }
    }

    protected void logRecord(long l, Object object, String string, String string2, String string3, Object[] objectArray) {
        if (string3 == null || !this.getSuppressedKeys().contains(string2)) {
            String string4 = object instanceof String ? (String)object : object.getClass().getName();
            LogRecord logRecord = new LogRecord(l, string4, string, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer(), string2, string3, objectArray);
            this.log(logRecord);
        }
    }

    protected void logRecord(long l, Object object, String string, Throwable throwable) {
        String string2 = object instanceof String ? (String)object : object.getClass().getName();
        LogRecord logRecord = new LogRecord(l, string2, string, this.getOrganization(), this.getProduct(), this.getComponent(), this.getClient(), this.getServer(), throwable);
        this.log(logRecord);
    }

    public void message(long l, Object object, String string, String string2) {
        if (this.isLogging) {
            this.logRecord(l, object, string, string2, this.getMessageFile(), null);
        }
    }

    public void message(long l, Object object, String string, String string2, Object object2) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{object2};
            this.logRecord(l, object, string, string2, this.getMessageFile(), objectArray);
        }
    }

    public void message(long l, Object object, String string, String string2, Object object2, Object object3) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{object2, object3};
            this.logRecord(l, object, string, string2, this.getMessageFile(), objectArray);
        }
    }

    public void message(long l, Object object, String string, String string2, Object[] objectArray) {
        if (this.isLogging) {
            this.logRecord(l, object, string, string2, this.getMessageFile(), objectArray);
        }
    }

    public void msg(long l, Object object, String string, String string2, String string3) {
        if (this.isLogging) {
            this.logRecord(l, object, string, string2, string3, null);
        }
    }

    public void msg(long l, Object object, String string, String string2, String string3, Object object2) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{object2};
            this.logRecord(l, object, string, string2, string3, objectArray);
        }
    }

    public void msg(long l, Object object, String string, String string2, String string3, Object object2, Object object3) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{object2, object3};
            this.logRecord(l, object, string, string2, string3, objectArray);
        }
    }

    public void msg(long l, Object object, String string, String string2, String string3, Object[] objectArray) {
        if (this.isLogging) {
            this.logRecord(l, object, string, string2, string3, objectArray);
        }
    }

    public void stackTrace(long l, Object object, String string) {
        if (this.isLogging) {
            this.logRecord(l, object, string, new LogStackTrace());
        }
    }

    public void stackTrace(long l, Object object, String string, String string2) {
        if (this.isLogging) {
            this.logRecord(l, object, string, new LogStackTrace(string2));
        }
    }

    public void text(long l, Object object, String string, String string2) {
        if (this.isLogging) {
            this.logRecord(l, object, string, string2, null, null);
        }
    }

    public void text(long l, Object object, String string, String string2, Object object2) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{object2};
            this.logRecord(l, object, string, string2, null, objectArray);
        }
    }

    public void text(long l, Object object, String string, String string2, Object object2, Object object3) {
        if (this.isLogging) {
            Object[] objectArray = new Object[]{object2, object3};
            this.logRecord(l, object, string, string2, null, objectArray);
        }
    }

    public void text(long l, Object object, String string, String string2, Object[] objectArray) {
        if (this.isLogging) {
            this.logRecord(l, object, string, string2, null, objectArray);
        }
    }
}

