/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging;

import com.ibm.logging.FileHandler;
import com.ibm.logging.IFormatter;
import com.ibm.logging.ILogRecord;
import com.ibm.logging.LogUtil;
import com.ibm.logging.NestedException;
import java.io.File;
import java.io.FilenameFilter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class MultiFileHandler
extends FileHandler {
    private static final String CR = "(C) Copyright IBM Corp. 1999.";
    static final long serialVersionUID = -4264888327332730757L;
    public static final int DEFAULT_FILES = 3;
    public static final int DEFAULT_FILE_SIZE = 512;
    protected transient long fileSize;
    private int maxFiles;
    private long maxFileSize;
    protected String baseFileName;
    protected String fileDir;
    protected String fileExt;

    public MultiFileHandler() {
    }

    public MultiFileHandler(String string) {
        super(string);
    }

    public MultiFileHandler(String string, String string2) {
        super(string, string2);
    }

    public MultiFileHandler(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public MultiFileHandler(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    private void buildWorkingName() {
        int n;
        String string = this.getFileName();
        String string2 = new File(string).getAbsolutePath();
        File file = new File(string2);
        this.fileDir = file.getParent();
        if (this.fileDir != null && !this.fileDir.endsWith(File.separator)) {
            this.fileDir = String.valueOf(this.fileDir) + File.separator;
        }
        if ((n = (string2 = file.getName()).lastIndexOf(46)) == -1) {
            this.baseFileName = string2;
        } else {
            this.baseFileName = string2.substring(0, n);
            this.fileExt = string2.substring(n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fileDir != null) {
            stringBuffer.append(this.fileDir);
        }
        stringBuffer.append(String.valueOf(this.baseFileName) + "1");
        if (this.fileExt != null) {
            stringBuffer.append(this.fileExt);
        }
        this.fileName = stringBuffer.toString();
    }

    protected Vector deleteExtraFiles(Vector vector, String string) {
        int n = this.getMaxFiles();
        if (n > 0) {
            while (vector.size() >= n) {
                File file = new File(String.valueOf(string) + (String)vector.firstElement());
                file.delete();
                vector.removeElement(vector.firstElement());
            }
        }
        return vector;
    }

    private void deleteFile() {
        if (this.getFileName() != null) {
            Enumeration enumeration = this.getDirList(this.fileDir).elements();
            while (enumeration.hasMoreElements()) {
                File file = new File(String.valueOf(this.fileDir) + (String)enumeration.nextElement());
                if (!file.exists() || file.delete()) continue;
                LogUtil.errorMsg(LogUtil.getLogMessage("ERR_DELETE_FILE", file.getName()));
            }
        }
    }

    public void deleteLog() throws AccessControlException {
        Object object = this.deviceLock;
        synchronized (object) {
            this.closeDevice();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                this.deleteFile();
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        MultiFileHandler.this.deleteFile();
                        return null;
                    }
                });
            }
        }
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        ((Hashtable)properties).put("maxFiles", new Integer(this.getMaxFiles()).toString());
        ((Hashtable)properties).put("maxFileSize", new Integer(this.getMaxFileSize()).toString());
        return properties;
    }

    protected Vector getDirList(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                boolean bl = false;
                int n = MultiFileHandler.this.getMaxFiles();
                try {
                    int n2;
                    int n3 = MultiFileHandler.this.baseFileName.length();
                    if (MultiFileHandler.this.fileExt == null) {
                        int n4;
                        if (string.startsWith(MultiFileHandler.this.baseFileName) && (n4 = Integer.parseInt(string.substring(n3))) >= 1 && (n == 0 || n4 <= n)) {
                            bl = true;
                        }
                    } else if (string.startsWith(MultiFileHandler.this.baseFileName) && string.endsWith(MultiFileHandler.this.fileExt) && (n2 = Integer.parseInt(string.substring(n3, string.indexOf(MultiFileHandler.this.fileExt)))) >= 1 && (n == 0 || n2 <= n)) {
                        bl = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                return bl;
            }
        };
        Vector<String> vector = new Vector<String>();
        String[] stringArray = file.list(filenameFilter);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(stringArray[n]);
                ++n;
            }
        }
        return this.sortFiles(vector);
    }

    public int getMaxFileSize() {
        return (int)(this.maxFileSize / 1024L);
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public String getNumberedFileName(int n) {
        String string;
        if (this.getFileName() == null || n < 1 || n > this.getMaxFiles()) {
            string = null;
        } else {
            string = String.valueOf(this.fileDir) + this.baseFileName + n;
            if (this.fileExt != null) {
                string = String.valueOf(string) + this.fileExt;
            }
        }
        return string;
    }

    public void init() {
        super.init();
        this.fileSize = 0L;
        this.setMaxFiles(3);
        this.setMaxFileSize(512);
        this.baseFileName = null;
        this.fileDir = null;
        this.fileExt = null;
    }

    protected void openFile() throws NestedException {
        if (!this.deviceOpen || this.fileSize >= this.maxFileSize) {
            this.closeDevice();
            if (this.fileSize >= this.maxFileSize) {
                Vector vector = this.getDirList(this.fileDir);
                vector = this.deleteExtraFiles(vector, this.fileDir);
                this.renameFiles(vector, this.fileDir);
            }
            super.openFile();
            this.fileSize = new File(this.getFileName()).length();
        }
    }

    protected void renameFiles(Vector vector, String string) {
        int n = vector.size() + 1;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.fileExt == null ? String.valueOf(this.baseFileName) + n : String.valueOf(this.baseFileName) + n + this.fileExt;
            File file = new File(String.valueOf(string) + string2);
            File file2 = new File(String.valueOf(string) + string3);
            file.renameTo(file2);
            --n;
        }
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("maxFiles");
        if (string != null) {
            this.setMaxFiles(new Integer(string));
        }
        if ((string = properties.getProperty("maxFileSize")) != null) {
            this.setMaxFileSize(new Integer(string));
        }
    }

    public void setFileName(String string) throws AccessControlException {
        if (string != null) {
            super.setFileName(string);
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                this.buildWorkingName();
            } else {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        MultiFileHandler.this.buildWorkingName();
                        return null;
                    }
                });
            }
        }
    }

    public void setMaxFileSize(int n) {
        if (n > 0) {
            this.maxFileSize = n * 1024;
        }
    }

    public void setMaxFiles(int n) {
        if (n >= 0) {
            this.maxFiles = n;
        }
    }

    protected Vector sortFiles(Vector vector) {
        int n = this.baseFileName.length();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            int n3 = n2 + 1;
            while (n3 < vector.size()) {
                int n4;
                int n5;
                String string2 = (String)vector.elementAt(n3);
                if (this.fileExt == null) {
                    n5 = Integer.parseInt(string.substring(n));
                    n4 = Integer.parseInt(string2.substring(n));
                } else {
                    n5 = Integer.parseInt(string.substring(n, string.indexOf(this.fileExt)));
                    n4 = Integer.parseInt(string2.substring(n, string2.indexOf(this.fileExt)));
                }
                if (n5 < n4) {
                    vector.setElementAt(string2, n2);
                    vector.setElementAt(string, n3);
                    string = string2;
                }
                ++n3;
            }
            ++n2;
        }
        return vector;
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string) + ", files=" + this.getMaxFiles() + ", fileSize=" + this.getMaxFileSize();
    }

    protected void writeRecord(ILogRecord iLogRecord) throws NestedException {
        this.openDevice();
        Object object = this.deviceLock;
        synchronized (object) {
            IFormatter iFormatter;
            if (this.deviceOpen && (iFormatter = this.findFormatter(iLogRecord)) != null) {
                String string = iFormatter.format(iLogRecord);
                this.fileSize += (long)string.length();
                this.pWriter.println(string);
                if (this.pWriter.checkError()) {
                    this.closeDevice();
                    throw new NestedException(LogUtil.getLogMessage("ERR_WRITE_MSG", this.getName()));
                }
            }
        }
    }
}

