/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.mgr;

import com.ibm.logging.mgr.IManageable;
import java.util.Enumeration;
import java.util.Properties;

public class Config
extends Properties {
    private static final String CR = "(C) Copyright IBM Corp. 1998, 1999.";
    static final long serialVersionUID = 7421144432808727090L;
    private boolean modified = false;
    private transient int inUseCount = 0;
    private transient IManageable object = null;

    public Config() {
    }

    public Config(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.setProperty(string, string2);
        }
    }

    public int decrementInUseCount() {
        if (this.inUseCount > 0) {
            --this.inUseCount;
        }
        return this.inUseCount;
    }

    public int getInUseCount() {
        return this.inUseCount;
    }

    public IManageable getObject() {
        return this.object;
    }

    public Properties getParent() {
        return this.defaults;
    }

    public int incrementInUseCount() {
        ++this.inUseCount;
        return this.inUseCount;
    }

    public synchronized boolean isModified() {
        return this.modified;
    }

    public void setInUseCount(int n) {
        if (n >= 0) {
            this.inUseCount = n;
        }
    }

    public synchronized void setModified(boolean bl) {
        this.modified = bl;
    }

    public void setObject(IManageable iManageable) {
        this.object = iManageable;
    }

    public void setParent(Properties properties) {
        this.defaults = properties;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    Configuration:\r\n");
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append("      " + string + ":  " + this.getProperty(string) + "\r\n");
        }
        stringBuffer.append("      In Use Count:  " + this.inUseCount + "\r\n");
        return stringBuffer.toString();
    }

    public void update() {
        IManageable iManageable = this.getObject();
        if (iManageable != null) {
            iManageable.setConfig(this);
        }
    }

    public void update(Config config) {
        IManageable iManageable;
        if (config != null && (iManageable = config.getObject()) != null) {
            this.setObject(iManageable);
            this.setInUseCount(config.getInUseCount());
            this.object.setConfig(this);
        }
    }
}

