/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.mgr;

import com.ibm.logging.IConstants;
import com.ibm.logging.LogIOException;
import com.ibm.logging.mgr.BaseGroup;
import com.ibm.logging.mgr.Config;
import com.ibm.logging.mgr.Group;
import com.ibm.logging.mgr.PropertyDataStore;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class SinglePropertyDataStore
extends PropertyDataStore
implements IConstants {
    private static final String CR = "(C) Copyright IBM Corp. 2000.";
    private static final String BASE_GROUP_NAME = "baseGroup";

    public SinglePropertyDataStore(String string) throws LogIOException {
        super(string);
    }

    public SinglePropertyDataStore(Properties properties) {
        super(properties);
    }

    public BaseGroup restoreConfig() {
        BaseGroup baseGroup = new BaseGroup();
        Properties properties = this.getPropertyDataStore();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            Group group;
            String string;
            String string2 = (String)enumeration.nextElement();
            if (string2.equals("defaultMessageLogger")) {
                string = properties.getProperty("defaultMessageLogger");
                baseGroup.setDefaultMessageLogger(string);
                continue;
            }
            if (string2.equals("defaultTraceLogger")) {
                string = properties.getProperty("defaultTraceLogger");
                baseGroup.setDefaultTraceLogger(string);
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            if (string3.equalsIgnoreCase(BASE_GROUP_NAME)) {
                group = baseGroup;
            } else {
                group = baseGroup.getGroup(string3);
                if (group == null) {
                    group = new Group(string3);
                    baseGroup.addGroup(group);
                }
            }
            Config config = group.getConfig(string4);
            if (config == null) {
                config = new Config();
                if (!string3.equals(BASE_GROUP_NAME)) {
                    config.setProperty("group", string3);
                }
                config.setProperty("name", string4);
                group.addConfig(config);
            }
            config.setProperty(string5, properties.getProperty(string2));
        }
        this.updateGroups(baseGroup);
        return baseGroup;
    }
}

