/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.server;

import com.ibm.logging.LogUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConnectionHandler
implements Runnable {
    private static final String CR = "(C) Copyright IBM Corp. 1998.";
    private boolean toFile = false;
    private PrintWriter pWriter = null;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss:SSS");
    private Socket socket = null;

    public ConnectionHandler(Socket socket, boolean bl, PrintWriter printWriter) {
        this.socket = socket;
        this.toFile = bl;
        this.pWriter = printWriter;
    }

    public void run() {
        SecurityManager securityManager = System.getSecurityManager();
        String string = securityManager == null ? this.socket.getInetAddress().getHostName() : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ConnectionHandler.this.socket.getInetAddress().getHostName();
            }
        });
        String string2 = df.format(new Date());
        this.write(LogUtil.getLogMessage("CONNECTION_OPENED", string, string2));
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        }
        catch (Throwable throwable) {
            this.write(LogUtil.getLogMessage("ERR_INPUT_STREAM"));
            this.write(throwable.getMessage());
            return;
        }
        try {
            while (true) {
                String string3 = null;
                string3 = bufferedReader.readLine();
                if (string3 == null) {
                    return;
                }
                this.write(string3);
            }
        }
        catch (Throwable throwable) {
            string2 = df.format(new Date());
            this.write(LogUtil.getLogMessage("CONNECTION_CLOSED", string, string2));
            this.write(throwable.getMessage());
            return;
        }
    }

    private void write(String string) {
        if (this.toFile) {
            this.pWriter.println(string);
        }
        System.out.println(string);
    }
}

