/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.server;

import com.ibm.logging.LogUtil;
import com.ibm.logging.server.ConnectionHandler;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class LogServer
implements Runnable {
    private static final String CR = "(C) Copyright IBM Corp. 1998.";
    private static final int DEFAULT_PORT = 9991;
    private boolean toFile = false;
    private int port = 9991;
    private PrintWriter pWriter = null;
    private ServerSocket serverSocket;
    private String filename = null;

    public LogServer(int n, String string) {
        this.port = n;
        this.filename = string;
        Thread thread = new Thread(this);
        thread.start();
    }

    public static void main(String[] stringArray) {
        int n = 0;
        String string = null;
        switch (stringArray.length) {
            case 0: {
                n = 9991;
                break;
            }
            case 1: {
                try {
                    n = Integer.valueOf(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("LS_USAGE"));
                    System.exit(1);
                }
                break;
            }
            case 2: {
                try {
                    n = Integer.valueOf(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("LS_USAGE"));
                    System.exit(1);
                }
                string = stringArray[1];
                break;
            }
            default: {
                LogUtil.errorMsg(LogUtil.getLogMessage("LS_USAGE"));
                System.exit(1);
            }
        }
        LogServer logServer = new LogServer(n, string);
    }

    public void run() {
        Object object;
        SecurityManager securityManager = System.getSecurityManager();
        if (this.filename != null) {
            this.toFile = true;
            try {
                FileOutputStream fileOutputStream;
                if (securityManager == null) {
                    fileOutputStream = new FileOutputStream(this.filename, true);
                } else {
                    try {
                        fileOutputStream = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                return new FileOutputStream(LogServer.this.filename, true);
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                }
                object = new OutputStreamWriter(fileOutputStream);
                this.pWriter = new PrintWriter((Writer)new BufferedWriter((Writer)object), true);
            }
            catch (IOException iOException) {
                LogUtil.errorMsg(LogUtil.getLogMessage("ERR_LS_OPEN_FILE", this.filename));
                iOException.printStackTrace();
            }
        } else {
            this.toFile = false;
        }
        try {
            this.write(LogUtil.getLogMessage("START_SERVER"));
            this.write(LogUtil.getLogMessage("CREATE_SOCKET", new Integer(this.port).toString()));
            if (this.toFile) {
                this.write(LogUtil.getLogMessage("OUTPUT_TO_FILE", this.filename));
            } else {
                this.write(LogUtil.getLogMessage("OUTPUT_TO_CONSOLE"));
            }
            if (securityManager == null) {
                this.serverSocket = new ServerSocket(this.port);
            } else {
                try {
                    this.serverSocket = (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            return new ServerSocket(LogServer.this.port);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
            }
            while (true) {
                Socket socket;
                if (securityManager == null) {
                    socket = this.serverSocket.accept();
                } else {
                    try {
                        socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                return LogServer.this.serverSocket.accept();
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                }
                object = new ConnectionHandler(socket, this.toFile, this.pWriter);
                Thread thread = new Thread((Runnable)object);
                thread.start();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    private void write(String string) {
        if (this.toFile) {
            this.pWriter.println(string);
        }
        System.out.println(string);
    }
}

