/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.utilities;

import com.ibm.logging.ILogRecord;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;

public class BackupFile {
    private static final String CR = "(C) Copyright IBM Corp. 2000.";
    public static final int DEFAULT_CAPACITY = 50000;
    private static final Object fileLock = new Object();
    private static final String NAME_START = "backup_";
    private static final String NAME_END = ".log";
    private File backupFile = null;
    private int recordCount = 0;
    private int capacity = 50000;
    private ObjectOutput objectOutput = null;
    private ObjectInput objectInput = null;
    private String name = null;

    public BackupFile() {
    }

    public BackupFile(int n) {
        this.capacity = n < 0 ? 50000 : n;
    }

    static /* synthetic */ ObjectOutput access$1(BackupFile backupFile) {
        return backupFile.objectOutput;
    }

    static /* synthetic */ ObjectInput access$3(BackupFile backupFile) {
        return backupFile.objectInput;
    }

    public void close() {
        Object object = fileLock;
        synchronized (object) {
            if (this.backupFile != null && this.backupFile.exists()) {
                try {
                    this.objectInput.close();
                    this.objectOutput.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void delete() throws AccessControlException {
        Object object = fileLock;
        synchronized (object) {
            if (this.backupFile != null && this.backupFile.exists()) {
                this.close();
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager == null) {
                    this.backupFile.delete();
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            BackupFile.this.backupFile.delete();
                            return null;
                        }
                    });
                }
            }
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public String getName() {
        return this.name;
    }

    public synchronized int getRecordCount() {
        return this.recordCount;
    }

    public synchronized boolean isEmpty() {
        return this.recordCount == 0;
    }

    public synchronized boolean isFull() {
        return this.recordCount >= this.capacity && this.capacity != 0;
    }

    public void open() throws IOException, AccessControlException {
        boolean bl = false;
        Random random = new Random();
        Object object = fileLock;
        synchronized (object) {
            while (!bl) {
                int n = random.nextInt();
                if (n < 0) {
                    n = -n;
                }
                this.name = NAME_START + new Integer(n).toString() + NAME_END;
                this.backupFile = new File(this.name);
                if (this.backupFile.exists()) continue;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager == null) {
                    this.objectOutput = new ObjectOutputStream(new FileOutputStream(this.name, true));
                    this.objectInput = new ObjectInputStream(new FileInputStream(this.name));
                } else {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                BackupFile.this.objectOutput = new ObjectOutputStream(new FileOutputStream(BackupFile.this.name, true));
                                BackupFile.this.objectInput = new ObjectInputStream(new FileInputStream(BackupFile.this.name));
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                }
                bl = true;
            }
        }
    }

    public synchronized ILogRecord readRecord() throws ClassNotFoundException, IOException {
        ILogRecord iLogRecord;
        block2: {
            iLogRecord = null;
            if (this.objectInput == null) break block2;
            try {
                iLogRecord = (ILogRecord)this.objectInput.readObject();
                --this.recordCount;
            }
            catch (EOFException eOFException) {}
        }
        return iLogRecord;
    }

    public synchronized void setCapacity(int n) {
        if (n >= 0) {
            this.capacity = n;
        }
    }

    public synchronized void writeRecord(ILogRecord iLogRecord) throws IOException {
        if (!this.isFull() && this.objectOutput != null) {
            this.objectOutput.writeObject(iLogRecord);
            this.objectOutput.flush();
            ++this.recordCount;
        }
    }
}

