/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.utilities;

import com.ibm.logging.ILogRecord;
import com.ibm.logging.LogUtil;
import com.ibm.logging.utilities.RecordQueue;

public class CircularRecordQueue
extends RecordQueue {
    private static final String CR = "(C) Copyright IBM Corp. 1999.";
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    private int head;
    private int tail;
    private ILogRecord[] queue = null;

    public CircularRecordQueue() {
        this(10000);
    }

    public CircularRecordQueue(int n) throws IllegalArgumentException {
        if (n < 1) {
            throw new IllegalArgumentException(LogUtil.getLogMessage("ERR_QUEUE_SIZE", new Integer(n)));
        }
        this.head = 0;
        this.tail = 0;
        this.queueCount = 0;
        this.setCapacity(n);
        this.queue = new ILogRecord[n];
    }

    public synchronized ILogRecord dequeue() {
        ILogRecord iLogRecord = this.first();
        if (iLogRecord != null) {
            this.head = (this.head + 1) % this.capacity;
            --this.queueCount;
        }
        return iLogRecord;
    }

    public synchronized boolean enqueue(ILogRecord iLogRecord) {
        if (iLogRecord != null) {
            this.queue[this.tail] = iLogRecord;
            if (this.queueCount < this.capacity) {
                ++this.queueCount;
            }
            if (this.tail == this.head && this.queueCount == this.capacity) {
                this.head = (this.head + 1) % this.capacity;
            }
            this.tail = (this.tail + 1) % this.capacity;
        }
        return true;
    }

    public synchronized ILogRecord first() {
        ILogRecord iLogRecord = null;
        if (!this.isEmpty()) {
            iLogRecord = this.queue[this.head];
        }
        return iLogRecord;
    }

    public boolean isCircular() {
        return true;
    }

    public synchronized boolean isFull() {
        return false;
    }

    public void setCapacity(int n) {
        if (n >= 1) {
            this.capacity = n;
        }
    }
}

