/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.logging.utilities;

import com.ibm.logging.ILogRecord;
import com.ibm.logging.LogUtil;
import com.ibm.logging.utilities.IRecordQueue;
import com.ibm.logging.utilities.RecordBasket;

public class RecordQueue
implements IRecordQueue {
    private static final String CR = "(C) Copyright IBM Corp. 1999.";
    protected int queueCount;
    protected int capacity;
    private RecordBasket head;
    private RecordBasket tail;

    public RecordQueue() {
        this(0);
    }

    public RecordQueue(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException(LogUtil.getLogMessage("ERR_QUEUE_SIZE", new Integer(n)));
        }
        this.head = null;
        this.tail = null;
        this.queueCount = 0;
        this.setCapacity(n);
    }

    public synchronized ILogRecord dequeue() {
        ILogRecord iLogRecord = null;
        if (!this.isEmpty()) {
            RecordBasket recordBasket = this.head;
            this.head = recordBasket.getNext();
            iLogRecord = (ILogRecord)recordBasket.getObject();
            --this.queueCount;
        }
        return iLogRecord;
    }

    public synchronized boolean enqueue(ILogRecord iLogRecord) {
        boolean bl = true;
        if (iLogRecord != null) {
            if (this.isFull()) {
                bl = false;
            } else {
                RecordBasket recordBasket = new RecordBasket(iLogRecord);
                if (this.isEmpty()) {
                    this.head = recordBasket;
                } else {
                    this.tail.setNext(recordBasket);
                }
                this.tail = recordBasket;
                ++this.queueCount;
            }
        }
        return bl;
    }

    public synchronized ILogRecord first() {
        return (ILogRecord)this.head.getObject();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public synchronized int getQueueCount() {
        return this.queueCount;
    }

    public boolean isCircular() {
        return false;
    }

    public synchronized boolean isEmpty() {
        return this.queueCount == 0;
    }

    public synchronized boolean isFull() {
        return this.queueCount >= this.capacity && this.capacity != 0;
    }

    public void setCapacity(int n) {
        if (n >= 0) {
            this.capacity = n;
        }
    }
}

